from __future__ import absolute_import
from __future__ import unicode_literals
from sys import version_info

from .base_serializer import BaseSerializer
from ...utils.log import Log


TAG = "SimpleSerializer"


if version_info[0] == 3:
    unicode = str


class SimpleSerializer(BaseSerializer):

    value_is_list = None
    value_type = None
    handle_types = (unicode, bytes, int, float, bool)

    def __init__(self, value_type):
        self.value_is_list, self.value_type = self.get_value_type(value_type)
        Log.d(TAG, "value_is_list, value_type: {},{}".format(
            self.value_is_list, self.value_type
        ))

    @staticmethod
    def raise_value_error(value, types_list):
        raise AttributeError(("No supported type detected: {}. "
                              "Required one of these: '{}'").format(
                                  value.__class__.__name__,
                                  ', '.join([x.__name__ for x in types_list])))

    def get_value_type(self, value_type):
        # If the value type is an array
        if isinstance(value_type, list) and len(value_type) == 1:
            return True, value_type[0]

        # Check if this is a simple value
        elif value_type in self.handle_types:
            return False, value_type

        raise AttributeError(("No supported type detected: {}. "
                              "required one of these: '{}'").format(
            value_type, ', '.join([x.__name__ for x in self.handle_types])
        ))

    def check_type(self, values):
        # type: (list) -> list
        dumped = list()
        for raw_data in values:
            if not isinstance(raw_data, self.value_type):
                self.raise_value_error(raw_data, [self.value_type])
            dumped.append(raw_data)
        return dumped

    def loads(self, value):
        if not self.value_is_list and not isinstance(value, list):
            self.check_type([value])
            return value

        elif self.value_is_list and isinstance(value, list):
            return self.check_type(value)

        self.raise_value_error(value, [self.value_type])

    def dumps(self, value):
        if value is None:
            return value

        if not self.value_is_list and not isinstance(value, list):
            self.check_type([value])
            return value

        elif self.value_is_list and isinstance(value, list):
            return self.check_type(value)

        self.raise_value_error(value, [self.value_type])
