from __future__ import absolute_import
from __future__ import unicode_literals
from .meta_model import JSONER_DATA_FIELD
from .base_model import BaseModel
from .functions import pythonize_str, jsonize_str
from ..exceptions import FieldRequired


try:
    import simplejson as json
except ImportError:
    import json


TAG = __name__


class ObjectModel(BaseModel):

    def loads(self, data):
        # type: (dict) -> any
        fields = getattr(self, JSONER_DATA_FIELD, {})
        for field_name, field in fields.items():
            j_field_name = field.get_field_name() or jsonize_str(field_name)
            loaded_value = data.get(j_field_name, None)
            j_field_value = field.loads(loaded_value)
            setattr(self, field_name, j_field_value)
        return self

    def dumps(self):
        # type: () -> dict
        dumped = dict()
        instance_fields = getattr(self, JSONER_DATA_FIELD, {})
        for field_name, field in instance_fields.items():
            j_field_name = field.get_field_name() or jsonize_str(field_name)
            if field.is_value_set():
                dumped_value = getattr(self, field_name, None)
                j_field_value = field.dumps(dumped_value)
                dumped[j_field_name] = j_field_value
        return dumped
