from __future__ import absolute_import
from abc import ABCMeta
from abc import abstractmethod
from ..decorators import with_metaclass


@with_metaclass(ABCMeta)
class BaseSerializer(object):

    @abstractmethod
    def loads(self, data):
        # type: (bytes) -> BaseSerializer
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    def dumps(self, data):
        # type: (any) -> bytes
        raise NotImplementedError("IMPL ME")