from __future__ import absolute_import
from __future__ import unicode_literals
from sys import version_info


if version_info[0] == 3:
    unicode = str


TAG = __name__


class BaseField(object):

    _field_name = None    # type: unicode
    _value_is_set = None  # type: bool
    _value = None         # type: any

    def get_value(self):
        return self._value

    def set_value(self, value):
        self._value_is_set = True
        self._value = value

    def del_value(self):
        self._value_is_set = False
        self._value = None

    def is_value_set(self):
        return self._value_is_set is True

    def get_field_name(self):
        return self._field_name

    def loads(self, data):
        # type: (any) -> any
        raise NotImplementedError("IMPL ME")

    def dumps(self, data):
        # type: (any) -> any
        raise NotImplementedError("IMPL ME")
