from __future__ import absolute_import
from ..serializers.simple_serializer import SimpleSerializer


TAG = "BaseField"


class BaseField(object):

    serializer = None
    null = None
    jsonize = None

    def __init__(self, value_type, serializer=SimpleSerializer, null=True,
                 jsonize=True):
        """
        :param value_type: type of the value we serialize
        :type  value_type: any
        :param serializer: Serializer class
        :type  serializer: any
        :param null: Do we need to send null if None is set
        :type  null: bool
        :param jsonize: Should we convert "test_name" to "testName" and back
        :type  jsonize: bool
        """
        self.serializer = serializer(value_type)
        self.null = null
        self.jsonize = jsonize

    def check_null(self, value):
        if value is None and self.null is not True:
            raise AttributeError("Value has to be not null: {}".format(value))
        return value

    def loads(self, value):
        return self.serializer.loads(value)

    def dumps(self, value):
        self.check_null(value)
        return self.serializer.dumps(value)
