from __future__ import absolute_import
from __future__ import unicode_literals
from sys import version_info
from .base_field import BaseField
from ..serializers.base_serializer import BaseSerializer
from ..serializers.simple_serializer import SimpleSerializer
from ..exceptions import FieldRequired

if version_info[0] == 3:
    unicode = str


TAG = __name__


class SimpleField(BaseField):

    _field_name = None  # type: unicode
    _field_type = None  # type: any
    _serializer = None  # type: BaseSerializer

    def __init__(self, field_type, field_name=None,
                 serializer=SimpleSerializer):
        """
        :param field_type: The type of field's value
        :param field_name: The name of the field
        :param serializer: The serializer of the field value
        :param null: Set's whether value can be null or not
        """
        self._field_type = field_type
        self._field_name = field_name
        self._serializer = serializer(field_type)

    def loads(self, value):
        return self._serializer.loads(value)

    def dumps(self, value):
        return self._serializer.dumps(value)
