from __future__ import absolute_import
from utils.log import Log
from .base_serializer import BaseSerializer


TAG = "SimpleSerializer"


class SimpleSerializer(BaseSerializer):

    value_is_list = None
    value_type = None
    handle_types = (str, bytes, int, float, bool)

    def __init__(self, value_type):
        self.value_is_list, self.value_type = self.get_value_type(value_type)
        Log.d(TAG, "value_is_list, value_type: {},{}".format(
            self.value_is_list, self.value_type
        ))

    @staticmethod
    def raise_value_error(value):
        raise AttributeError("Could not handle value: {}".format(value))

    def get_value_type(self, value_type):
        # If the value type is an array
        if isinstance(value_type, list) and len(value_type) == 1:
            return True, value_type[0]

        # Check if this is a simple value
        elif value_type in self.handle_types:
            return False, value_type

        return self.raise_value_error(value_type)

    def check_type(self, values):
        # type: (list) -> list
        dumped = list()
        for raw_data in values:
            if not isinstance(raw_data, self.value_type):
                self.raise_value_error(raw_data)
            dumped.append(raw_data)
        return dumped

    def loads(self, value):
        if not self.value_is_list and not isinstance(value, list):
            self.check_type([value])
            return value

        elif self.value_is_list and isinstance(value, list):
            return self.check_type(value)

        return self.raise_value_error(value)

    def dumps(self, value):
        if not self.value_is_list and not isinstance(value, list):
            self.check_type([value])
            return value

        elif self.value_is_list and isinstance(value, list):
            return self.check_type(value)

        return self.raise_value_error(value)
