from __future__ import absolute_import
from __future__ import unicode_literals
from .decorators import with_metaclass
from .meta_model import MetaModel
try:
    import simplejson as json
except ImportError:
    import json


TAG = __name__


@with_metaclass(MetaModel)
class BaseModel(object):

    def __init__(self, *args, **kwargs):
        pass

    def loads(self, data):
        raise NotImplementedError("IMPL ME")

    def dumps(self):
        raise NotImplementedError("IMPL ME")

    @classmethod
    def from_json(cls, data):
        # type: (unicode) -> any
        self = cls.__new__(cls)
        return self.loads(json.loads(data))

    def to_json(self):
        # type: (any) -> unicode
        return json.dumps(self.dumps())
