from __future__ import absolute_import
from __future__ import unicode_literals
from ..fields.base_field import BaseField


TAG = __name__


JSONER_DATA_FIELD = "_jsoner_fields"


class MetaModel(type):

    def __new__(cls, name, bases, attrs):

        # Creating a new class jsoner_field
        jsoner_field_cls = attrs.pop(JSONER_DATA_FIELD, {})

        # Creating a base classes jsoner_field
        jsoner_field_base = {}

        # Creating the new class
        new_cls = super(MetaModel, cls).__new__(cls, name, bases, attrs)

        # Copying base blasses jsoner_fields
        for base in bases:
            if hasattr(base, JSONER_DATA_FIELD):
                jsoner_field_base.update(getattr(base, JSONER_DATA_FIELD, {}))

        # Setting the new class jsoner_field
        for k, v in attrs.items():
            if isinstance(v, BaseField):
                # Here's the place where the magic comes!
                jsoner_field_cls[k] = v

                def get_value(self):
                    return v.get_value()

                def set_value(self, value):
                    return v.set_value(value)

                def del_value(self):
                    return v.del_value()

                setattr(new_cls, k, property(get_value,
                                             set_value,
                                             del_value))
        jsoner_field = dict()
        jsoner_field.update(jsoner_field_base)
        jsoner_field.update(jsoner_field_cls)  # overwrites base fields!
        setattr(new_cls, JSONER_DATA_FIELD, jsoner_field)
        return new_cls

    def __call__(cls, *args, **kwargs):
        instance = type.__call__(cls)
        for name, field in getattr(instance, JSONER_DATA_FIELD, {}).items():
            if name in kwargs:
                setattr(instance, name, kwargs.get(name))
        return type.__call__(cls)
