from __future__ import absolute_import
from __future__ import unicode_literals


def pythonize_str(data):
    # Converts name to a python style names:
    # simpleTestValue -> simple_test_value
    new_data = ""
    for i in range(len(data)):
        curr_chr = data[i]
        if curr_chr.isupper():
            new_data += "_" + curr_chr.lower()
        else:
            new_data += curr_chr
    return new_data


def jsonize_str(data):
    # Converts data to a json style names:
    # simple_test_value -> simpleTestValue
    new_data = ''
    for i in range(len(data)):
        curr_chr = data[i]
        if curr_chr == '_':
            continue
        elif i == 0:
            # first char is always lower case! don't care if it isn't alpha.
            new_data += curr_chr.lower()
        elif curr_chr.isalpha() and data[i - 1] == '_':
            # If alpha and prev chr is '_' we push it in upper case.
            new_data += curr_chr.upper()
        elif not curr_chr.isalpha() and data[i - 1] == '_':
            # If not alpha and we copy prev and curr not changed.
            new_data += "_" + curr_chr
        else:
            new_data += curr_chr
    return new_data
