#!/usr/bin/env python
# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import traceback
import logging


try:
    import threading
except ImportError: #pragma: no cover
    threading = None


if threading:
    _lock = threading.RLock()
else: #pragma: no cover
    _lock = None


def _acquireLock():
    """
    Acquire the module-level lock for serializing access to shared data.

    This should be released with _releaseLock().
    """
    if _lock:
        _lock.acquire()

def _releaseLock():
    """
    Release the module-level lock acquired by calling _acquireLock().
    """
    if _lock:
        _lock.release()


class Log(object):

    logger = logging.getLogger()
    handler = logging.StreamHandler()

    handler.setLevel(logging.DEBUG)
    logger.setLevel(logging.DEBUG)
    logger.addHandler(handler)

    tags = dict()

    @staticmethod
    def get_or_create_tag(tag):
        # TODO(s1z): Finish this please
        _acquireLock()
        try:
            if tag in Log.tags:
                return Log.tags[tag]
        finally:
            _releaseLock()

    @staticmethod
    def log(level, tag, message, ex):
        if ex is not None:
            # exc_type, exc_value, exc_traceback = sys.exc_info()
            message = "%s\n%s" % (message, traceback.format_exc())
        msg = "{}::{}".format(tag, message)
        Log.logger.log(level, msg)

    @staticmethod
    def v(tag, message, ex=None):
        """ Thers is no VERBOSE in python logging we use DEBUG """
        return Log.log(logging.DEBUG, tag, message, ex)

    @staticmethod
    def d(tag, message, ex=None):
        return Log.log(logging.DEBUG, tag, message, ex)

    @staticmethod
    def i(tag, message, ex=None):
        return Log.log(logging.INFO, tag, message, ex)

    @staticmethod
    def w(tag, message, ex=None):
        return Log.log(logging.WARN, tag, message, ex)

    @staticmethod
    def e(tag, message, ex=None):
        return Log.log(logging.ERROR, tag, message, ex)
