from __future__ import absolute_import
from __future__ import unicode_literals
import logging


def init_logging(filename=None, level=None):
    """ init logging on the app level """
    logging_config = {"format": "%(asctime)-23s %(levelname)8s::"
                                "%(name)s::%(funcName)s:"
                                "%(message)s",
                      "level": level or logging.DEBUG}
    if filename is not None:
        logging_config["filename"] = filename
    logging.getLogger().handlers = []
    logging.basicConfig(**logging_config)
