""" This is a base handler """
import logging

from aiohttp import web
from aiohttp.web_request import Request
from aiohttp.web_response import Response


class BaseHandler:
    """ API V1 Health Check """

    METHOD = None
    PATH = None

    async def handler(self, _: Request) -> Response:
        """ The handler """
        raise NotImplementedError()

    def compile(self):
        """ compile into the route """
        logger = logging.getLogger(self.__module__)
        logger.info(f"{self.METHOD}:{self.PATH}")
        return web.route(self.METHOD, self.PATH, self.handler)

    def _get_name(self):
        """ Get handler name """
        return f"{self.__module__}.{self.__class__.__name__}"
