""" Kraken data packet implementation """
from dataclasses import dataclass
from datetime import datetime, timedelta

from ..basic_dataclass import BasicDataclass


@dataclass
class KrPacket(BasicDataclass):
    """ Kraken Packet """

    t_stamp: int
    latitude: float
    longitude: float
    gps_bearing: int
    radio_bearing: int  # int or float ???
    conf: float
    power: float
    freq: int
    ant_type: str
    latency: int  # useless shit
    doa_array: str
    id: str

    def __repr__(self):
        return f"<KrP: {self.id}::{self.radio_bearing}>"


@dataclass
class KrPacketV2(BasicDataclass):
    """ Kraken Packet V2 """

    adc_overdrive: int
    num_corr_sources: str
    snr_db: float
    serial: str
    # doa_array: str
    station_id: str
    t_stamp: int
    gps_timestamp: int
    latitude: float
    longitude: float
    gps_bearing: float
    radio_bearing: float  # str(int)
    conf: float
    power: float
    freq: int
    ant_type: str
    latency: int
    processing_time: int
    compass_offset: float = 0

    def get_timestamp(self):
        """ get timestamp """
        return (
            datetime.fromtimestamp(self.t_stamp / 1000)
            + timedelta(hours=3)  # this is a hack, fix it pls!
        ).strftime('%Y-%m-%d %H:%M:%S')

    def get_absolute_doa(self):
        """ get absolute doa """
        absolute_bearing = self.gps_bearing + (360 - self.radio_bearing)
        if absolute_bearing < 0:
            absolute_bearing += 360
        elif absolute_bearing > 359:
            absolute_bearing -= 360

        if self.compass_offset != 0:
            absolute_bearing += self.compass_offset
        return absolute_bearing

    def __repr__(self):
        return f"{self.get_timestamp()}::{self.station_id}::" \
               f"frequency: {self.freq / 1000000}, " \
               f"DoA: {self.get_absolute_doa()}, " \
               f"confidence: {self.conf}, " \
               f"power: {self.power}"
