""" PA message to send to Teams """
from dataclasses import dataclass, field
from typing import Optional, Union, List, Dict, Any

from entities.json.camel_case_mixin import CamelCaseMixin, uuid_factory
from entities.json.ttl_record import TTLRecord


@dataclass
class PAMessage(CamelCaseMixin):
    """ PA message Schema """
    id: Optional[str]
    conversation_id: str
    tenant_id: str
    card: Optional[Any] = None
    ttl: Optional[TTLRecord] = None
