""" PA message to send to Teams """
from dataclasses import dataclass, field
from typing import List

from entities.json.camel_case_mixin import CamelCaseMixin


@dataclass
class MarsReportFile(CamelCaseMixin):
    """ Mars Report File Metadata """
    file_name: str
    content_type: str
    size: int
    url: str


@dataclass
class MarsReport(CamelCaseMixin):
    """ ClientUploadSession Form """
    files: List[MarsReportFile] = field(default_factory=list)
