""" Cleaner client """
import logging
import aiohttp


log = logging.getLogger()


class CleanerClient:
    """ Cleaner Client class """
    PATH_TTL = "/api/v1/ttl"

    def __init__(self, domain_name: str):
        self.domain_name = domain_name

    async def notify_new_ttl(self, ttl: int):
        """ Notify cleaner with the new ttl received """
        url = f"{self.domain_name}{self.PATH_TTL}"
        async with aiohttp.ClientSession() as session:
            async with session.post(url, json=dict(ttl=ttl)) as response:
                log.info(f"response: {response}")
