""" PA message to send to Teams """
from dataclasses import dataclass, field
from typing import Optional, Union, List, Dict, Any

from entities.json.camel_case_mixin import CamelCaseMixin, uuid_factory
from entities.json.content_ttl import ContentTTL


@dataclass
class PAMessage(CamelCaseMixin):
    """ PA message Schema """
    id: Optional[str]
    conversation_id: str
    tenant_id: str
    card: Optional[Any] = None
    content_t_t_l: Optional[ContentTTL] = None
    message_id: Optional[str] = None
