def with_metaclass(meta):
    def decorator(cls):
        attrs = vars(cls).copy()
        attrs.pop('__dict__', None)
        attrs.pop('__weakref__', None)
        return meta(cls.__name__, cls.__bases__, attrs)
    return decorator
