import asyncio
import types
from asyncio import coroutine

from .abstract_service import AbstractService
from .backends.abstract_backend import AbstractBackend
from .backends.systemd.systemd_backend import SystemdBackend


TAG = __name__


def ensure_backend(f):
    async def wr(self, *args, **kwargs):
        if self.backend is None:
             self.backend = await self.get_supported_backend()
        result = f(self, *args, **kwargs)
        print("f result:", result)
        if asyncio.iscoroutine(result) or isinstance(result, asyncio.Future):
            return await result
        return result
    return wr


class ServiceController(object):

    backend: AbstractBackend = None

    def __init__(self, backend=None):
        if backend is not None:
            self.backend = backend

    @staticmethod
    async def get_supported_backend():
        if await SystemdBackend.is_supported():
            return SystemdBackend()
        # add backends here
        raise AttributeError("Can't get supported Service Backend")

    @ensure_backend
    def create(self, service):
        """
        :param AbstractService service: Service object
        :rtype: asyncio.Future[bool]
        """
        return self.backend.create(service)

    @ensure_backend
    async def delete(self, service):
        """
        :param service:
        :type service: AbstractService
        :rtype: asyncio.Future[bool]
        """
        return self.backend.delete(service)

    @ensure_backend
    async def start(self, service):
        """
        :param service:
        :type service: AbstractService
        :rtype: asyncio.Future[bool]
        """
        return self.backend.start(service)

    @ensure_backend
    async def stop(self, service):
        """
        :param service:
        :type service: AbstractService
        :rtype: asyncio.Future[bool]
        """
        return self.backend.stop(service)

    @ensure_backend
    async def restart(self, service):
        """
        :param service:
        :type service: AbstractService
        :rtype: asyncio.Future[bool]
        """
        return await self.backend.restart(service)
