from abc import ABCMeta, abstractmethod

from ..abstract_service import AbstractService
from ..utils.decorators import with_metaclass


@with_metaclass(ABCMeta)
class AbstractBackend(object):

    @classmethod
    @abstractmethod
    async def is_supported(cls):
        """
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    async def create(self, service):
        """
        :param AbstractService service:
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    async def delete(self, service):
        """
        :param AbstractService service:
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    async def start(self, service):
        """
        :param AbstractService service:
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    async def stop(self, service):
        """
        :param AbstractService service:
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")

    @abstractmethod
    async def restart(self, service):
        """
        :param AbstractService service:
        :rtype: bool
        """
        raise NotImplementedError("IMPL ME")
