package com.android.mobile.ui.fragments;

import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceFragmentCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.android.mobile.R;
import com.android.mobile.util.FocusHandler;


public class PreferencesFragment extends PreferenceFragmentCompat {

    public static final int ID = 7;

    private static final String PREFERENCES_PARENTAL_CONTROL    = "preferences_parental_control";
    private static final String PREFERENCES_LANGUAGE            = "preferences_language";
    private static final String PREFERENCES_DEVICE_INFORMATION  = "preferences_device_information";

    public static PreferencesFragment newInstance(Bundle bundle) {
        PreferencesFragment fragment = new PreferencesFragment();
        if (bundle != null) {
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    public PreferencesFragment() {
    }

    @Override
    public void onCreatePreferences(Bundle savedInstanceState, String rootKey) {
        addPreferencesFromResource(R.xml.app_preference);

        findPreference(PREFERENCES_PARENTAL_CONTROL).setOnPreferenceClickListener(
                new CategoryClickListener(PREFERENCES_PARENTAL_CONTROL)
        );

        findPreference(PREFERENCES_LANGUAGE).setOnPreferenceClickListener(
                new CategoryClickListener(PREFERENCES_LANGUAGE)
        );

        findPreference(PREFERENCES_DEVICE_INFORMATION).setOnPreferenceClickListener(
                new CategoryClickListener(PREFERENCES_DEVICE_INFORMATION)
        );
    }

    @Override
    public RecyclerView onCreateRecyclerView(LayoutInflater inflater, ViewGroup parent, Bundle savedInstanceState) {
        RecyclerView view = super.onCreateRecyclerView(inflater, parent, savedInstanceState);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            view.setBackgroundColor(getResources().getColor(android.R.color.white, null));
        } else {
            view.setBackgroundColor(getResources().getColor(android.R.color.white));
        }
        return view;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onResume() {
        super.onResume();

        FocusHandler.setVisible(ID);
    }

    private class CategoryClickListener implements Preference.OnPreferenceClickListener {

        private String category;

        public CategoryClickListener(String category) {
            this.category = category;
        }

        @Override
        public boolean onPreferenceClick(Preference preference) {
            Fragment fragment = null;
            switch (category) {
                case PREFERENCES_PARENTAL_CONTROL:
                    fragment = new AccountFragment();
                    break;
                case PREFERENCES_LANGUAGE:
                    fragment = new AccountFragment();
                    break;
                case PREFERENCES_DEVICE_INFORMATION:
                    fragment = new AccountFragment();
                    break;
                default:
                    throw new AssertionError();
            }
            if (fragment != null) {

                FragmentTransaction fragmentTransaction = getActivity()
                        .getSupportFragmentManager()
                        .beginTransaction();
                fragmentTransaction.replace(R.id.container, fragment);
                fragmentTransaction.addToBackStack(null);
                fragmentTransaction.commit();
            }
            return true;
        }
    }

}
