package com.android.mobile.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.android.mobile.R;

import butterknife.BindView;
import butterknife.ButterKnife;


public class DummyFragment extends Fragment {

    private static final String TAG = DummyFragment.class.getSimpleName();

    public static final String DUMMY_KEY = "dummy_key";
    public int mDummyId;
    @BindView(R.id.dummy) public TextView mDummyTextView;

    public static DummyFragment newInstance(Bundle bundle) {
        DummyFragment fragment = new DummyFragment();
        if (bundle != null) {
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.dummy_fragment, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        mDummyId = getArguments().getInt(DUMMY_KEY);
        String text = "Dummy";

        switch (mDummyId) {
            case 0: text = "One"; break;
            case 1: text = "Two"; break;
            case 2: text = "Three"; break;
            case 3: text = "Four"; break;
            case 4: text = "Five"; break;
            case 5: text = "Six"; break;
        }
        mDummyTextView.setText(text);
    }
}
