package com.android.mobile.ui.animation;

import android.view.View;

import com.daimajia.androidanimations.library.YoYo;
import com.daimajia.androidanimations.library.fading_entrances.FadeInAnimator;
import com.daimajia.androidanimations.library.fading_exits.FadeOutAnimator;


public class Fade {

    private long duration = 500;

    private FadeInAnimator fadeIn;
    private FadeOutAnimator fadeOut;

    public Fade() {
        this.fadeIn = new FadeInAnimator();
        this.fadeOut = new FadeOutAnimator();
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return duration;
    }

    public void fadeIn(View view) {
        YoYo.with(fadeIn).duration(duration).playOn(view);
    }

    public void fadeOut(View view) {
        YoYo.with(fadeOut).duration(duration).playOn(view);
    }
}
