package com.android.mobile.ui.adapters;

import android.support.v7.widget.RecyclerView;
import android.view.View;


public abstract class TrackSelectionAdapter<VH extends TrackSelectionAdapter.ViewHolder> extends RecyclerView.Adapter<VH> {

    private int focused = 0;

    TrackSelectionAdapter() {
        setHasStableIds(true);
    }

    public boolean tryMoveSelection(RecyclerView mRecyclerView, int direction) {
        int tryFocusItem = focused + direction;

        if (tryFocusItem >= 0 && tryFocusItem < getItemCount()) {
            notifyItemChanged(focused);
            focused = tryFocusItem;
            mRecyclerView.smoothScrollToPosition(focused);
            notifyItemChanged(focused);
            return true;
        }

        return false;
    }

    @Override
    public void onBindViewHolder(VH viewHolder, int i) {
        viewHolder.itemView.setSelected(focused == i);
    }

    public int getFocusedItem() {
        return focused;
    }

    public void setFocused(Integer focused) {
        notifyItemChanged(this.focused);
        this.focused = focused;
        notifyItemChanged(focused);
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);

            itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    notifyItemChanged(focused);
                    focused = getLayoutPosition();
                    notifyItemChanged(focused);
                }
            });
        }

        public View getView() {
            return itemView;
        }

    }
}
