package com.android.mobile.ui.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.android.mobile.R;
import com.android.mobile.database.model.ChannelRecord;
import com.android.mobile.ui.ScalableCardView;

import java.util.List;


public class LinearTrackSelectionAdapter extends TrackSelectionAdapter<LinearTrackSelectionAdapter.ViewHolder> {

    private LayoutInflater mLayoutInflater;
    private List<ChannelRecord> mChannels;

    class ViewHolder extends TrackSelectionAdapter.ViewHolder {
        ViewHolder(View itemView) {
            super(itemView);
        }

        public ScalableCardView getView() {
            return (ScalableCardView) itemView;
        }
    }

    public LinearTrackSelectionAdapter(Context context, List<ChannelRecord> mChannels) {
        this.mChannels = mChannels;
        this.mLayoutInflater = LayoutInflater.from(context);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        final ScalableCardView view = (ScalableCardView) mLayoutInflater.inflate(R.layout.scaled_card_view_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        super.onBindViewHolder(viewHolder, position);
        ScalableCardView view = viewHolder.getView();
        view.bind(mChannels.get(position), view.isSelected(), position);
    }

    @Override
    public void onViewRecycled(ViewHolder holder) {
        super.onViewRecycled(holder);
        holder.getView().unbind();
    }

    @Override
    public int getItemCount() {
        return mChannels != null ? mChannels.size() : 0;
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public List<ChannelRecord> getChannels() {
        return mChannels;
    }

    public void swap(List<ChannelRecord> channels) {
        this.mChannels = channels;
        notifyDataSetChanged();
    }
}
