package com.android.mobile.ui.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.android.mobile.R;
import com.android.mobile.database.model.ChannelRecord;
import com.android.mobile.ui.ScalableCardView;

import java.util.List;


public class GridTrackSelectionAdapter extends TrackSelectionAdapter<GridTrackSelectionAdapter.ViewHolder> {

    private LayoutInflater inflater;
    private List<ChannelRecord> channels;

    public GridTrackSelectionAdapter(@NonNull Context context, @Nullable List<ChannelRecord> channels) {
        this.inflater = LayoutInflater.from(context);
        this.channels = channels;
    }

    class ViewHolder extends TrackSelectionAdapter.ViewHolder {
        public ViewHolder(View itemView) {
            super(itemView);
        }
        public ScalableCardView getView() {
            return (ScalableCardView) itemView;
        }
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ScalableCardView view = (ScalableCardView)
                inflater.inflate(R.layout.scaled_card_view_item, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder viewHolder, int index) {
        super.onBindViewHolder(viewHolder, index);

        ChannelRecord record = channels.get(index);

        viewHolder.getView().bind(record, getFocusedItem() == index, index);
    }

    @Override
    public int getItemCount() {
        return channels != null ? channels.size() : 0;
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public void onViewDetachedFromWindow(ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        holder.getView().clearAnimation();
    }

    public void swap(List<ChannelRecord> channels) {
        this.channels = channels;
        notifyDataSetChanged();
    }
}
