package com.android.mobile.ui.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.android.mobile.R;
import com.android.mobile.util.ViewUtil;

import java.util.List;


public class BaseListAdapter extends TrackSelectionAdapter<BaseListAdapter.ViewHolder> {

    class ViewHolder extends TrackSelectionAdapter.ViewHolder {

        private TextView mTextView;

        public ViewHolder(View itemView) {
            super(itemView);

            this.mTextView = (TextView) itemView.findViewById(R.id.item);
        }

        public TextView getTextItem() {
            return mTextView;
        }

        public LinearLayout getItem() {
            return (LinearLayout) itemView;
        }
    }

    private Context context;
    private List<String> data;
    private LayoutInflater inflater;

    public BaseListAdapter(Context context, List<String> data) {
        setHasStableIds(true);
        this.context = context;
        this.data = data;
        this.inflater = LayoutInflater.from(context);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(inflater.inflate(R.layout.account_menu_item, parent, false));
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        super.onBindViewHolder(holder, position);

        LinearLayout item = holder.getItem();
        holder.getTextItem().setText(data.get(position));

        if (item.isSelected()) {
            ViewUtil.setBackgroundColor(context, item, R.color.amber_900);
        } else {
            ViewUtil.setBackgroundColor(context, item, R.color.grey_800);
        }
    }

    @Override
    public int getItemCount() {
        return data != null ? data.size() : 0;
    }

    @Override
    public int getItemViewType(int position) {
        return position;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

}
