package com.android.mobile.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;

import com.android.mobile.R;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;


public class AutoHideView extends FrameLayout implements AutoHideInterface {

    private final static String TAG = AutoHideView.class.getSimpleName();

    private final int DEFAULT_TIME = 3000;

    private ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();

    private AutoHideTimerTask task = null;
    private boolean isAnimate = false;
    private Animation mFadeIn;
    private Animation mFadeOut;
    private int time;

    public AutoHideView(Context context) {
        super(context);

        task = new AutoHideTimerTask(this);
        service.schedule(task, DEFAULT_TIME, TimeUnit.MILLISECONDS);
    }

    public AutoHideView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);

        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.AutoHideView, 0, 0);
        try {
            isAnimate = a.getBoolean(R.styleable.AutoHideView_isAnimate, false);
            time = a.getInteger(R.styleable.AutoHideView_time, DEFAULT_TIME);
        } finally {
            a.recycle();
        }
        if (isAnimate) {
            mFadeIn = AnimationUtils.loadAnimation(context, android.R.anim.fade_in);
            mFadeIn.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {}

                @Override
                public void onAnimationEnd(Animation animation) {
                    setVisibility(VISIBLE);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {}
            });

            mFadeOut = AnimationUtils.loadAnimation(context, android.R.anim.fade_out);
            mFadeOut.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {

                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    setVisibility(GONE);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }
            });
        }

        task = new AutoHideTimerTask(this, isAnimate);
        service.schedule(task, time, TimeUnit.MILLISECONDS);
    }

    @Override
    public void reset() {

        if (service != null) {
            service.shutdown();
            service.shutdownNow();
            service = null;
        }

        service = Executors.newSingleThreadScheduledExecutor();

        task = new AutoHideTimerTask(this, isAnimate);
        service.schedule(task, time, TimeUnit.MILLISECONDS);
    }

    @Override
    public void show() {
        if (isAnimate) {
            startAnimation(mFadeIn);
        } else {
            setVisibility(VISIBLE);
        }

        reset();
    }

    @Override
    public void hide() {

        if (service != null) {
            service.shutdown();
            service.shutdownNow();
            service = null;
        }

        if (isAnimate) {
            startAnimation(mFadeOut);
        } else {
            setVisibility(GONE);
        }
    }
}
