package com.android.mobile.ui;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;

import java.util.TimerTask;


public class AutoHideTimerTask extends TimerTask {

    private static final String TAG = AutoHideView.class.getSimpleName();

    private Handler handler = new Handler(Looper.getMainLooper());
    private View mView;
    private boolean isAnimate = false;
    private Animation animation;

    public AutoHideTimerTask(View view) {
        this(view, false);
    }

    public AutoHideTimerTask(View view, boolean isAnimate) {
        this.mView = view;
        if (isAnimate) {
            animation = AnimationUtils.loadAnimation(view.getContext(), android.R.anim.fade_out);
            animation.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {}

                @Override
                public void onAnimationEnd(Animation animation) {
                    mView.setVisibility(View.GONE);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {}
            });
        }
        this.isAnimate = isAnimate;
    }

    @Override
    public void run() {
        hide();
    }

    private void hide() {
        handler.post(new Runnable() {
            @Override
            public void run() {
                if (isAnimate) {
                    mView.startAnimation(animation);
                } else {
                    mView.setVisibility(View.GONE);
                }
            }
        });
    }
}
