package com.android.mobile.dependencies.module;

import com.android.mobile.api.controller.AccountController;
import com.android.mobile.api.controller.ChannelController;

import javax.inject.Named;
import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;


@Module
public class RetrofitModule {

    private String url;

    public RetrofitModule(String url) {
        this.url = url;
    }

    @Provides
    @Singleton
    @Named("TLSConnection")
    Retrofit provideSecureRetrofit(@Named("TLS") OkHttpClient okHttpClient) {
        return new Retrofit.Builder()
                .baseUrl(url)
                .addConverterFactory(GsonConverterFactory.create())
                .client(okHttpClient)
                .build();
    }

    @Provides
    @Singleton
    AccountController provideAccountController(@Named("TLSConnection") Retrofit retrofit) {
        return new AccountController(retrofit);
    }

    @Provides
    @Singleton
    ChannelController provideChannelController(@Named("TLSConnection") Retrofit retrofit) {
        return new ChannelController(retrofit);
    }
}
