package com.android.mobile.dependencies.module;

import android.content.Context;

import com.android.mobile.database.DatabaseHelper;
import com.android.mobile.database.model.ChannelRecordDao;
import com.android.mobile.database.model.DaoMaster;
import com.android.mobile.database.model.DaoSession;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;


@Module
public class DatabaseModule {

    @Provides
    @Singleton
    DatabaseHelper provideDatabaseHelper(Context context) {
        return new DatabaseHelper(context);
    }

    @Provides
    @Singleton
    DaoSession provideDatabaseSession(DatabaseHelper helper) {
        return new DaoMaster(helper.getWritableDatabase()).newSession();
    }

    @Provides
    @Singleton
    ChannelRecordDao provideChannelDatabase(DaoSession session) {
        return session.getChannelRecordDao();
    }

}
