package com.android.mobile.api.controller;

import com.android.mobile.api.STBResponse;
import com.android.mobile.api.retrofit.RetrofitCallback;
import com.android.mobile.api.retrofit.service.ChannelService;
import com.android.mobile.exception.NonSuccessfulResponseException;

import java.io.IOException;

import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;


public class ChannelController {

    private ChannelService channelService;
    private Callback callback;

    public ChannelController(Retrofit retrofit) {
        channelService = retrofit.create(ChannelService.class);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void getChannels() {
        callback.onRun();
        Call<STBResponse> call = channelService.getChannels();
        call.enqueue(new ChannelCallbackQueue());
    }

    private class ChannelCallbackQueue implements retrofit2.Callback<STBResponse> {
        @Override
        public void onResponse(Call<STBResponse> call, Response<STBResponse> response) {
            if (response.isSuccessful()) {
                callback.onSuccess(response.body());
            } else {
                try {
                    callback.onFailure(new NonSuccessfulResponseException(response.errorBody().string()));
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

        }

        @Override
        public void onFailure(Call<STBResponse> call, Throwable t) {
            callback.onFailure(new NonSuccessfulResponseException(t.getMessage()));
        }
    }

    public interface Callback extends RetrofitCallback {
        void onRun();
        void onSuccess(STBResponse response);
        void onFailure(Throwable throwable);
    }

}
