package com.android.mobile;

import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.KeyEvent;

import com.android.mobile.ui.fragments.ChannelsFragment;
import com.android.mobile.ui.fragments.MenuFragment;
import com.android.mobile.util.FocusHandler;


public class MainActivity extends BaseActivity {

    private static final String TAG = MainActivity.class.getSimpleName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    @Override
    protected void onResume() {
        super.onResume();

        getSupportFragmentManager()
                .beginTransaction()
                .replace(R.id.container, ChannelsFragment.newInstance(null))
                .commit();
    }

    @Override
    public void onBackPressed() {
        if (FocusHandler.isMenuOpen()) {
            getSupportFragmentManager().popBackStack(MenuFragment.class.getName(),
                    FragmentManager.POP_BACK_STACK_INCLUSIVE);
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        final boolean unique = event.getRepeatCount() == 0;
        if (unique) {
            if (keyCode == KeyEvent.KEYCODE_MENU) {
                showMenuFragment();
                return true;
            } else if (keyCode == KeyEvent.KEYCODE_BACK) {
                onBackPressed();
                return true;
            }
        }
        return false;
    }

    private void showMenuFragment() {
        if (FocusHandler.isMenuOpen()) {
            getSupportFragmentManager().popBackStack(MenuFragment.class.getName(),
                    FragmentManager.POP_BACK_STACK_INCLUSIVE);
            FocusHandler.setMenuOpen(false);
        } else {
            getSupportFragmentManager().beginTransaction()
                    .setCustomAnimations(R.anim.slide_from_top, R.anim.slide_to_top,
                            R.anim.slide_from_top, R.anim.slide_to_top)
                    .add(R.id.container, MenuFragment.newInstance(null))
                    .addToBackStack(MenuFragment.class.getName())
                    .commit();
        }
    }
}
