package com.android.mobile;

import android.app.Application;

import com.android.mobile.dependencies.component.ApplicationComponent;
import com.android.mobile.dependencies.component.DaggerApplicationComponent;
import com.android.mobile.dependencies.module.AnimationModule;
import com.android.mobile.dependencies.module.ApplicationModule;
import com.android.mobile.dependencies.module.DatabaseModule;
import com.android.mobile.dependencies.module.NetworkModule;
import com.android.mobile.dependencies.module.RetrofitModule;
import com.android.mobile.security.TelevisionTrustStore;


public class ApplicationContext extends Application {

    private static ApplicationComponent component;

    @Override
    public void onCreate() {
        super.onCreate();

        component = DaggerApplicationComponent.builder()
                .networkModule(new NetworkModule(new TelevisionTrustStore(this)))
                .retrofitModule(new RetrofitModule(BuildConfig.MOBILE_TV_URL))
                .databaseModule(new DatabaseModule())
                .applicationModule(new ApplicationModule(this))
                .animationModule(new AnimationModule())
                .build();
    }

    public static ApplicationComponent getComponent() {
        return component;
    }

}
