package com.android.mobile.util;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class Util {

    public static Handler handler = new Handler(Looper.getMainLooper());
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("[a-zA-Z_0-9]{6,16}");
    private static final Pattern EMAIL_PATTERN = android.util.Patterns.EMAIL_ADDRESS;
    private static final Pattern SERIAL_PATTERN = Pattern.compile("[A-Z]{0,3}[0-9]{5,30}");

    public static boolean isValidPassword(String password) {
        Matcher matcher = PASSWORD_PATTERN.matcher(password);
        return matcher.matches();
    }

    public static boolean isValidEmail(String email) {
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.matches();
    }

    public static boolean isValidSerial(String serial) {
        Matcher matcher = SERIAL_PATTERN.matcher(serial);
        return matcher.matches();
    }

    public static int calculateNoOfColumns(Context context, int width) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        float dpWidth = displayMetrics.widthPixels / displayMetrics.density;
        return (int) (dpWidth / width);
    }

    public static String md5(String input) {
        return getHash("MD5", input);
    }

    private static String getHash(String alg, String input) {
        MessageDigest algorithm = getAlgorithm(alg);
        if (algorithm != null) {
            try {
                return Hex.byteArrayToHexString(algorithm.digest(input.getBytes("UTF-8")));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static void runOnMainThread(@NonNull Runnable runnable) {
        if (isMainThread()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private static MessageDigest getAlgorithm(String algo) {
        try {
            return MessageDigest.getInstance(algo);
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

}
