package com.android.mobile.util;

import android.content.Context;
import android.os.Build;
import android.preference.PreferenceManager;

public class Preferences {

    private static final String TAG = Preferences.class.getSimpleName();

    private static final String USER_LOGIN = "pref_user_login";
    private static final String USER_PASS = "pref_user_pass";
    private static final String USER_IDENTIFIER = "pref_user_identifier";
    private static final String USER_ISP = "pref_user_isp";

    public static String getUserIsp(Context context) {
        return getStringPreference(context, USER_ISP, "default");
    }

    public static void setUserIsp(Context context, String isp) {
        setStringPreference(context, USER_ISP, isp);
    }

    public static void setUserIdentifier(Context context, String identifier) {
        setStringPreference(context, USER_IDENTIFIER, identifier);
    }

    public static String getUserIdentifier(Context context) {
        return getStringPreference(context, USER_IDENTIFIER, Build.SERIAL);
    }

    public static void setUserLogin(Context context, String login) {
        setStringPreference(context, USER_LOGIN, login);
    }

    public static String getUserLogin(Context context) {
        return getStringPreference(context, USER_LOGIN, null);
    }

    public static void setUserPassword(Context context, String pass) {
        setStringPreference(context, USER_PASS, pass);
    }

    public static String getUserPassword(Context context) {
        return getStringPreference(context, USER_PASS, null);
    }

    public static void setBooleanPreference(Context context, String key, boolean value) {
        PreferenceManager.getDefaultSharedPreferences(context).edit().putBoolean(key, value).apply();
    }

    public static boolean getBooleanPreference(Context context, String key, boolean defaultValue) {
        return PreferenceManager.getDefaultSharedPreferences(context).getBoolean(key, defaultValue);
    }

    public static void setStringPreference(Context context, String key, String value) {
        PreferenceManager.getDefaultSharedPreferences(context).edit().putString(key, value).apply();
    }

    public static String getStringPreference(Context context, String key, String defaultValue) {
        return PreferenceManager.getDefaultSharedPreferences(context).getString(key, defaultValue);
    }

    private static int getIntegerPreference(Context context, String key, int defaultValue) {
        return PreferenceManager.getDefaultSharedPreferences(context).getInt(key, defaultValue);
    }

    private static void setIntegerPrefrence(Context context, String key, int value) {
        PreferenceManager.getDefaultSharedPreferences(context).edit().putInt(key, value).apply();
    }

    private static boolean setIntegerPrefrenceBlocking(Context context, String key, int value) {
        return PreferenceManager.getDefaultSharedPreferences(context).edit().putInt(key, value).commit();
    }

    private static long getLongPreference(Context context, String key, long defaultValue) {
        return PreferenceManager.getDefaultSharedPreferences(context).getLong(key, defaultValue);
    }

    private static void setLongPreference(Context context, String key, long value) {
        PreferenceManager.getDefaultSharedPreferences(context).edit().putLong(key, value).apply();
    }

}
