package com.android.mobile.util;

import com.android.mobile.database.model.ChannelRecord;

import java.util.ArrayList;
import java.util.List;


public class ApplicationProvider {

    public static final int COLUMN_COUNT = 3;
    public static final int MOVE_UP = -COLUMN_COUNT;
    public static final int MOVE_DOWN = +COLUMN_COUNT;
    public static final int MOVE_LEFT = -1;
    public static final int MOVE_RIGHT = +1;
    public static final int HOLD = 0;

    public interface Menu {
        int CHANNELS = 1;
        int ACCOUNT = 2;
        int PREFERENCES = 3;
        int LOGOUT = 4;
    }

    public interface Account {
        int MOVE_UP = -1;
        int MOVE_DOWN = +1;
    }

    private static Integer CURRENT = 0;
    private static List<ChannelRecord> CHANNELS = new ArrayList<>();

    public static void fillCache(List<ChannelRecord> channels) {
        CHANNELS = channels;
    }

    public static List<ChannelRecord> getChannels() {
        return CHANNELS;
    }

    public static ChannelRecord getById(int id) throws IllegalArgumentException {
        if (id < 0) {
            throw new IllegalArgumentException();
        }
        return CHANNELS.get(id);
    }

    public static void setCurrent(int current) {
        CURRENT = current;
    }

    public static Integer getCurrent() {
        return CURRENT;
    }

    public static ChannelRecord getChannel(String title) {
        for (ChannelRecord channel : CHANNELS) {
            if (channel.getTitle().equals(title)) {
                return channel;
            }
        }
        return null;
    }

    public static ChannelRecord getChannel(ChannelRecord channel) {
        for (ChannelRecord channel1 : CHANNELS) {
            if (channel1.equals(channel)) {
                return channel1;
            }
        }
        return null;
    }

    public static int size() {
        return CHANNELS.size();
    }

    public static int lastIndex() {
        return size() - 1;
    }
}
