package com.android.mobile.util;

import android.view.View;

import com.android.mobile.ui.animation.Fade;
import com.android.mobile.ui.animation.Zoom;
import com.daimajia.androidanimations.library.YoYo;
import com.daimajia.androidanimations.library.attention.WobbleAnimator;


public class AnimationUtil {

    private Zoom zoom;
    private WobbleAnimator wobble;
    private Fade fade;

    public AnimationUtil() {
        zoom = new Zoom();
        wobble = new WobbleAnimator();
        fade = new Fade();
    }

    public void zoomIn(View view) {
        zoom.zoomIn(view);
    }

    public void zoomOut(View view) {
        zoom.zoomOut(view);
    }

    public void wobble(View view) {
        YoYo.with(wobble).playOn(view);
    }

    public void fadeIn(View... views) {
        for (View v : views) {
            fade.fadeIn(v);
        }
    }

    public void fadeOut(View... views) {
        for (View v : views) {
            fade.fadeOut(v);
        }
    }

    public Zoom getZoom() {
        return zoom;
    }

    public WobbleAnimator getWobble() {
        return wobble;
    }

    public Fade getFade() {
        return fade;
    }
}
