package com.android.mobile.util;

import com.android.mobile.R;

import java.util.Map;

public class APIUtil {

    // TODO: test values
    private static final String MICROSOFT = "0";
    private static final String ORACLE = "1";
    private static final String PAY_PAL = "2";

    public static boolean isResponseOK(Map<String, String> response) {
        String status = response.get("status_code");
        return status != null && status.equalsIgnoreCase("200");
    }

    public static boolean hasISP(Map<String, String> response) {
        String isp = response.get("isp");
        return isp != null && !isp.isEmpty();
    }

    public static int getISPLogo(String isp) {
        switch (isp) {
            case MICROSOFT:
                return R.drawable.microsoft;
            case ORACLE:
                return R.drawable.oracle;
            case PAY_PAL:
                return R.drawable.paypal;
        }
        return R.drawable.google;
    }

}
