package com.android.mobile.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.android.mobile.R;
import com.android.mobile.util.Preferences;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;


public class DeviceNotRegisteredFragment extends Fragment {

    private static final String TAG = DeviceNotRegisteredFragment.class.getSimpleName();

    public static final int ID = 0;

    @BindView(R.id.sign_in_button) public Button mSignIn;
    @BindView(R.id.sign_up_button) public Button mSignUp;
    @BindView(R.id.change_serial) public Button mChangeSerial;
    @BindView(R.id.serial_number) public TextView mSerial;

    public static DeviceNotRegisteredFragment newInstance(Bundle bundle) {
        DeviceNotRegisteredFragment instance = new DeviceNotRegisteredFragment();
        if (bundle != null) {
            instance.setArguments(bundle);
        }
        return instance;
    }

    public DeviceNotRegisteredFragment() {
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.device_not_registered_fragment, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        mSerial.setText(Preferences.getUserIdentifier(getContext()));
    }

    @OnClick(R.id.sign_in_button) public void signIn() {
        getFragmentManager().beginTransaction()
                .replace(R.id.container, SignInFragment.newInstance(null))
                .addToBackStack(SignInFragment.class.getSimpleName())
                .commit();
    }

    @OnClick(R.id.sign_up_button) public void signUp() {
        getFragmentManager().beginTransaction()
                .replace(R.id.container, SignUpFragment.newInstance(null))
                .addToBackStack(SignUpFragment.class.getSimpleName())
                .commit();
    }

    @OnClick(R.id.change_serial) public void changeSerial() {
        getFragmentManager().beginTransaction()
                .replace(R.id.container, ChangeSerialFragment.newInstance(null))
                .addToBackStack(ChangeSerialFragment.class.getSimpleName())
                .commit();
    }
}
