package com.android.mobile.ui.fragments;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.Toast;

import com.android.mobile.PlayerActivity;
import com.android.mobile.R;
import com.android.mobile.api.STBResponse;
import com.android.mobile.api.controller.ChannelController;
import com.android.mobile.database.model.ChannelRecord;
import com.android.mobile.dependencies.Injector;
import com.android.mobile.ui.adapters.GridTrackSelectionAdapter;
import com.android.mobile.ui.divider.HorizontalDividerItemDecoration;
import com.android.mobile.ui.divider.VerticalDividerItemDecoration;
import com.android.mobile.ui.snappysmoothscroller.SnapType;
import com.android.mobile.ui.snappysmoothscroller.SnappyGridLayoutManager;
import com.android.mobile.util.ApplicationProvider;
import com.android.mobile.util.FocusHandler;
import com.android.mobile.util.Util;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.inject.Inject;

import butterknife.BindView;
import butterknife.ButterKnife;


public class ChannelsFragment extends Fragment implements ChannelController.Callback {

    private static final String TAG = ChannelsFragment.class.getSimpleName();

    public static final int ID = 5;

    private ProgressDialog progressDialog;
    @BindView(R.id.recycler_view) public RecyclerView recyclerView;
    private GridTrackSelectionAdapter adapter;
    @Inject ChannelController mChannelController;

    public static ChannelsFragment newInstance(Bundle bundle) {
        ChannelsFragment instance = new ChannelsFragment();
        if (bundle != null) {
            instance.setArguments(bundle);
        }
        return instance;
    }

    public ChannelsFragment() {
        Injector.inject(this);
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mChannelController.setCallback(this);
        mChannelController.getChannels();
    }

    public void startPlayerActivity(int id) {
        setCurrentPlay(id);

        Intent intent = new Intent(getActivity(), PlayerActivity.class);
        intent.putExtra(PlayerActivity.CHANNEL_ID_EXTRA, id);

        startActivity(intent);

        getActivity().overridePendingTransition(R.anim.slide_from_left, R.anim.slide_to_right);
    }

    private void setCurrentPlay(int id) {
        ApplicationProvider.setCurrent(id);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.channels_fragment, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        recyclerView.setHasFixedSize(true);

        recyclerView.addItemDecoration(new VerticalDividerItemDecoration.Builder(getContext())
                .sizeResId(R.dimen.divider_vertical_margin)
                .colorResId(android.R.color.transparent)
                .build());

        recyclerView.addItemDecoration(new HorizontalDividerItemDecoration.Builder(getContext())
                .sizeResId(R.dimen.divider_horizontal_margin)
                .colorResId(android.R.color.transparent)
                .build());

        adapter = new GridTrackSelectionAdapter(getActivity(), null);

        SnappyGridLayoutManager snappyGridLayoutManager = new SnappyGridLayoutManager(getContext(), ApplicationProvider.COLUMN_COUNT);
        snappyGridLayoutManager.setSnapType(SnapType.CENTER);
        snappyGridLayoutManager.setSnapInterpolator(new DecelerateInterpolator());

        recyclerView.setLayoutManager(snappyGridLayoutManager);

        recyclerView.setAdapter(adapter);
        recyclerView.setItemViewCacheSize(32);
        recyclerView.setDrawingCacheEnabled(true);
        recyclerView.setDrawingCacheQuality(View.DRAWING_CACHE_QUALITY_HIGH);
        recyclerView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        recyclerView.getItemAnimator().setChangeDuration(5);
        recyclerView.getItemAnimator().setMoveDuration(100);

        recyclerView.setOnKeyListener(new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    boolean isUnique = event.getRepeatCount() == 0;
                    if (isUnique) {
                        switch (keyCode) {
                            case KeyEvent.KEYCODE_DPAD_RIGHT:
                                return adapter.tryMoveSelection(recyclerView, ApplicationProvider.MOVE_RIGHT);
                            case KeyEvent.KEYCODE_DPAD_LEFT:
                                return adapter.tryMoveSelection(recyclerView, ApplicationProvider.MOVE_LEFT);
                            case KeyEvent.KEYCODE_DPAD_UP:
                                return adapter.tryMoveSelection(recyclerView, ApplicationProvider.MOVE_UP);
                            case KeyEvent.KEYCODE_DPAD_DOWN:
                                return adapter.tryMoveSelection(recyclerView, ApplicationProvider.MOVE_DOWN);
                            case KeyEvent.KEYCODE_DPAD_CENTER:
                                startPlayerActivity(adapter.getFocusedItem());
                                return true;
                        }
                    }

                }
                return false;
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();

        FocusHandler.setVisible(ID);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();

        dismiss();
    }

    @Override
    public void onRun() {
        progressDialog = ProgressDialog.show(getActivity(), getString(R.string.ChannelsFragment__loading),
                getString(R.string.ChannelsFragment__wait_please_while_loading_channels));
        progressDialog.setCancelable(false);
    }

    @Override
    public void onSuccess(final STBResponse response) {
        // FIXME: It's not smart enough @equa1s
        new AsyncTask<Void,Void,List<ChannelRecord>>() {
            @Override
            protected List<ChannelRecord> doInBackground(Void[] params) {
                Map<String, String> data = response.getData();
                if (data != null && !data.isEmpty()) {
                    List<ChannelRecord> remoteRecords = new Gson().fromJson(data.get("channels"), new TypeToken<ArrayList<ChannelRecord>>(){}.getType());
                    if (remoteRecords != null && !remoteRecords.isEmpty()) {
                        ApplicationProvider.fillCache(remoteRecords);
                        return remoteRecords;
                    }
                }
                return null;
            }

            @Override
            protected void onPostExecute(final List<ChannelRecord> channels) {
                super.onPostExecute(channels);

                Util.runOnMainThread(new Runnable() {
                    @Override
                    public void run() {
                        if (adapter != null) {
                            adapter.swap(channels);
                        }
                    }
                });

                dismiss();
            }

        }.execute();
    }

    @Override
    public void onFailure(Throwable throwable) {
        dismiss();
        Toast.makeText(getActivity(), throwable.getMessage().substring(0, 50) + "...", Toast.LENGTH_SHORT).show();
    }

    private void dismiss() {
        if (progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

}
