package com.android.mobile.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;

import com.android.mobile.ApplicationContext;
import com.android.mobile.R;
import com.android.mobile.dependencies.Injector;
import com.android.mobile.util.AnimationUtil;
import com.android.mobile.util.Preferences;
import com.android.mobile.util.Util;

import javax.inject.Inject;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;


public class ChangeSerialFragment extends Fragment {

    private static final String TAG = ChangeSerialFragment.class.getSimpleName();

    public static final int ID = 2;

    @BindView(R.id.serial) public EditText mSerial;
    @BindView(R.id.save_serial) public Button mSaveSerial;
    @Inject AnimationUtil animationUtil;

    public static ChangeSerialFragment newInstance(Bundle bundle) {
        ChangeSerialFragment instance = new ChangeSerialFragment();
        if (bundle != null) {
            instance.setArguments(bundle);
        }
        return instance;
    }

    public ChangeSerialFragment() {
        Injector.inject(this);
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.change_serial_fragment, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @OnClick(R.id.save_serial) public void saveSerial() {

        String serial = mSerial.getText().toString();

        if (serial.isEmpty()) {
            mSerial.setError(getString(R.string.change_serial_fragment__save_serial));
            animationUtil.wobble(mSerial);
            return;
        }

        if (!Util.isValidSerial(serial)) {
            mSerial.setError(getString(R.string.change_serial_fragment__serial_is_not_valid));
            animationUtil.wobble(mSerial);
            return;
        }

        Preferences.setUserIdentifier(getContext(), serial);

        getFragmentManager().beginTransaction()
                .replace(R.id.container, CheckSerialFragment.newInstance(null))
                .addToBackStack(CheckSerialFragment.class.getSimpleName())
                .commit();
    }

}
