package com.android.mobile.ui.fragments;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.android.mobile.R;
import com.android.mobile.ui.LoadingView;
import com.android.mobile.ui.adapters.BaseListAdapter;
import com.android.mobile.util.ApplicationProvider;
import com.android.mobile.util.FocusHandler;

import java.util.Arrays;

import butterknife.BindArray;
import butterknife.BindView;
import butterknife.ButterKnife;


public class AccountFragment extends Fragment implements View.OnKeyListener {

    private static final String TAG = AccountFragment.class.getSimpleName();

    public static final int ID = 6;

    @BindArray(R.array.account_menu_items) public String[] mMenuItems;
    @BindView(R.id.menu_recycler_view) public RecyclerView mMenuRecyclerView;
    @BindView(R.id.menu_item_details) public FrameLayout mMenuItemDetails;
    @BindView(R.id.loading_view) public LoadingView mLoadingView;

    public static AccountFragment newInstance(Bundle bundle) {
        AccountFragment fragment = new AccountFragment();
        if (bundle != null) {
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    @Nullable
    @Override
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.account_fragment, container, false);
        ButterKnife.bind(this, view);
        return view;
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        mMenuRecyclerView.setHasFixedSize(true);
        mMenuRecyclerView.setLayoutManager(new LinearLayoutManager(getActivity(), LinearLayoutManager.VERTICAL, false));
        mMenuRecyclerView.setAdapter(new BaseListAdapter(getActivity(), Arrays.asList(mMenuItems)));
        mMenuRecyclerView.setOnKeyListener(this);
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        addFragment();
    }

    @Override
    public void onResume() {
        super.onResume();

        FocusHandler.setVisible(ID);
    }

    @Override
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == KeyEvent.ACTION_DOWN) {
            boolean isUnique = event.getRepeatCount() == 0;
            int direction = 0;
            if (isUnique) {
                if (keyCode == KeyEvent.KEYCODE_DPAD_UP) {
                    direction = ApplicationProvider.Account.MOVE_UP;
                } else if (keyCode == KeyEvent.KEYCODE_DPAD_DOWN) {
                    direction = ApplicationProvider.Account.MOVE_DOWN;
                }
                getAdapter().tryMoveSelection(mMenuRecyclerView, direction);
                replaceFragment();
            }
        }
        return false;
    }

    private BaseListAdapter getAdapter() {
        return (BaseListAdapter) mMenuRecyclerView.getAdapter();
    }

    private void replaceFragment() {
        getFragmentManager().beginTransaction()
                .replace(R.id.menu_item_details, DummyFragment.newInstance(getPackage()))
                .setCustomAnimations(R.anim.fade_scale_in, R.anim.fade_scale_out)
                .commit();
    }

    private void addFragment() {
        getFragmentManager().beginTransaction()
                .add(R.id.menu_item_details, DummyFragment.newInstance(getPackage()))
                .setCustomAnimations(R.anim.fade_scale_in, R.anim.fade_scale_out)
                .commit();
    }

    private Bundle getPackage() {
        Bundle bundle = new Bundle();
         bundle.putInt(DummyFragment.DUMMY_KEY, getAdapter().getFocusedItem());

        return bundle;
    }
}
