package com.android.mobile.ui.animation;

import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;


public class Zoom {

    private static final float CENTER_PIVOT = .5f;

    private static final float START_X_SCALE = 1f;
    private static final float START_Y_SCALE = 1f;

    private static final float END_X_SCALE = 1.1f;
    private static final float END_Y_SCALE = 1.2f;

    private static final float TRANSLATION_IN_Z = 2f;
    private static final float TRANSLATION_OUT_Z = 1f;

    private static final long DURATION_OUT = 250;
    private static final long DURATION_IN = 350;

    public Zoom() {
    }

    public void zoomIn(View view) {
        Animation scaleIn = new ScaleAnimation(START_X_SCALE, END_X_SCALE, START_Y_SCALE, END_Y_SCALE,
                Animation.RELATIVE_TO_SELF, CENTER_PIVOT, Animation.RELATIVE_TO_SELF, CENTER_PIVOT);
        scaleIn.setFillAfter(true);
        scaleIn.setDuration(DURATION_IN);
        view.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        ViewCompat.setTranslationZ(view, TRANSLATION_IN_Z);
        view.startAnimation(scaleIn);
    }

    public void zoomOut(View view) {
        Animation scaleOut = new ScaleAnimation(END_X_SCALE, START_X_SCALE, END_Y_SCALE, START_Y_SCALE,
                Animation.RELATIVE_TO_SELF, CENTER_PIVOT, Animation.RELATIVE_TO_SELF, CENTER_PIVOT);
        scaleOut.setFillAfter(true);
        scaleOut.setDuration(DURATION_OUT);
        view.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        ViewCompat.setTranslationZ(view, TRANSLATION_OUT_Z);
        view.startAnimation(scaleOut);
    }

}
