package com.android.mobile.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;

import com.android.mobile.ApplicationContext;
import com.android.mobile.database.model.ChannelRecord;
import com.android.mobile.dependencies.Injector;
import com.android.mobile.util.AnimationUtil;

import javax.inject.Inject;


public class ScalableCardView extends BaseCardView {

    @Inject AnimationUtil mAnimationUtil;

    public ScalableCardView(Context context) {
        super(context);
    }

    public ScalableCardView(Context context, AttributeSet attrs) {
        super(context, attrs);

        Injector.inject(this);
    }

    @Override
    public void bind(@NonNull ChannelRecord channel, boolean isSelected, int position) {
        super.bind(channel, isSelected, position);
        setScale(isSelected);
    }

    public void setScale(boolean isScale) {
        if (isScale) {
            mAnimationUtil.zoomIn(this);
        } else {
            mAnimationUtil.zoomOut(this);
        }
    }
}
