package com.android.mobile.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.util.AttributeSet;
import android.widget.ProgressBar;

import com.android.mobile.R;


public class LoadingView extends ProgressBar {

    private static final int DEFAULT_COLOR = Color.WHITE;

    public LoadingView(Context context) {
        super(context);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);

        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.LoadingView, 0, 0);

        int color;
        try {
            color = a.getColor(R.styleable.LoadingView_color_filter, DEFAULT_COLOR);
        } finally {
            a.recycle();
        }

        getIndeterminateDrawable().setColorFilter(color, PorterDuff.Mode.SRC_IN);

    }

    public void setVisibility(boolean visibility) {
        if (visibility) {
            show();
        } else {
            hide();
        }
    }

    private void show() {
        setVisibility(VISIBLE);
    }

    private void hide() {
        setVisibility(GONE);
    }
}
