package com.android.mobile.ui;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.android.mobile.R;
import com.android.mobile.database.model.ChannelRecord;
import com.android.mobile.util.ViewUtil;

import butterknife.BindView;
import butterknife.ButterKnife;


public class BaseCardView extends CardView implements BindableCardView {

    private ChannelRecord channel;

    @BindView(R.id.poster)      public ImageView      poster;
    @BindView(R.id.title)       public TextView       title;
    @BindView(R.id.description) public TextView       description;
    @BindView(R.id.container)   public RelativeLayout container;

    public BaseCardView(Context context) {
        super(context);
    }

    public BaseCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        ButterKnife.bind(this);
    }

    @Override
    public void bind(@NonNull ChannelRecord channel, boolean isSelected, int position) {
        ViewUtil.loadImage(getContext(), poster, channel.getBgImage());
        setBackground(isSelected);
        title.setText(channel.getTitle());
        description.setText(channel.getCategory());
    }

    @Override
    public void unbind() {
        if (channel != null) {
            channel = null;
        }
    }

    private void setBackground(boolean isSelected) {
        if (isSelected) {
            ViewUtil.setBackgroundColor(getContext(), container, R.color.blue_600);
        } else {
            ViewUtil.setBackgroundColor(getContext(), container, R.color.grey_600);
        }
    }
}
