package com.android.mobile.dependencies.module;

import android.content.Context;

import com.android.mobile.ApplicationContext;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;


@Module
public class ApplicationModule {

    private ApplicationContext application;

    public ApplicationModule(ApplicationContext application) {
        this.application = application;
    }

    @Provides
    @Singleton
    ApplicationContext provideApplicationContext() {
        return application;
    }

    @Provides
    @Singleton
    Context provideContext() {
        return application.getApplicationContext();
    }
}
