package com.android.mobile.dependencies.component;

import com.android.mobile.PlayerActivity;
import com.android.mobile.dependencies.module.AnimationModule;
import com.android.mobile.dependencies.module.ApplicationModule;
import com.android.mobile.dependencies.module.DatabaseModule;
import com.android.mobile.dependencies.module.NetworkModule;
import com.android.mobile.dependencies.module.RetrofitModule;
import com.android.mobile.ui.ScalableCardView;
import com.android.mobile.ui.fragments.ChangeSerialFragment;
import com.android.mobile.ui.fragments.ChannelsFragment;
import com.android.mobile.ui.fragments.CheckSerialFragment;
import com.android.mobile.ui.fragments.MenuFragment;
import com.android.mobile.ui.fragments.SignInFragment;
import com.android.mobile.ui.fragments.SignUpFragment;

import javax.inject.Singleton;

import dagger.Component;


@Singleton
@Component(dependencies = {}, modules = {NetworkModule.class,
                                         RetrofitModule.class,
                                         DatabaseModule.class,
                                         ApplicationModule.class,
                                         AnimationModule.class})
public interface ApplicationComponent {
    void inject(SignInFragment signInFragment);
    void inject(ChangeSerialFragment changeSerialFragment);
    void inject(SignUpFragment signUpFragment);
    void inject(ChannelsFragment channelsFragment);
    void inject(PlayerActivity playerActivity);
    void inject(ScalableCardView scalableCardView);
    void inject(MenuFragment menuFragment);
    void inject(CheckSerialFragment checkSerialFragment);
}
